<?php
namespace Elementor;

class imagebox1 extends Widget_Base {
	
	public function get_name() {
		return 'imagebox1';
	}
	
	public function get_title() {
		return 'دسته بندی 401';
	}
	
 public function get_icon() {
		return 'eicon eicon-menu-bar';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }

	
	protected function register_controls() {


		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'عنوان خود را وارد کنید', 'elementor' ),
			]
		);
		$this->add_control(
			'title1',
			[
				'label' => __( 'زیر عنوان', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'عنوان خود را وارد کنید', 'elementor' ),
			]
		);

				$this->add_control(
			'link',
			[
				'label' => __( 'لینک دسته بندی', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'ادرس لینک را وارد کنید', 'elementor' ),
			]
		);

		$this->add_control(
			'icon',
			[
				'label' => __( 'ایکون', 'text-domain' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);
				$this->add_control(
			'image',
			[
				'label' => __( 'تصویر دسته بندی', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		     $this->end_controls_section();


        
	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
             
			 
$this->add_control(
			'color',
			[
				'label' => __( 'رنگ دور تصویر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .box-simage-havine-2 img' => 'background: {{VALUE}}',
				],
			]
		);

$this->add_control(
			'color56',
			[
				'label' => __( 'رنگ کادر تصویر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .box-simage-havine-2 img' => 'border-color: {{VALUE}}',
				],
			]
		);

$this->add_control(
			'color2',
			[
				'label' => __( 'رنگ نیم دایره', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .circle98' => 'border-color: {{VALUE}}',
				],
			]
		);

$this->add_control(
			'color3',
			[
				'label' => __( 'رنگ پس زمینه ایکون', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .box-simage-havine-2 i' => 'background: {{VALUE}}',
				],
			]
		);

$this->add_control(
			'color4',
			[
				'label' => __( 'رنگ ایکون', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .box-simage-havine-2 i' => 'color: {{VALUE}}',
				],
			]
		);

$this->add_control(
			'color5',
			[
				'label' => __( 'رنگ عنوان اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .havine-345345-34534 h4' => 'color: {{VALUE}}',
				],
			]
		);
$this->add_control(
			'color6',
			[
				'label' => __( 'رنگ زیر عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .havine-345345-34534 h6' => 'color: {{VALUE}}',
				],
			]
		);

   $this->add_responsive_control(
                        'farnamborder1',
                        [
                            'label' => esc_html__( 'گردی تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .box-simage-havine-2 img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );



   $this->add_responsive_control(
                        'farnamborder3',
                        [
                            'label' => esc_html__( 'گردی نیم دایره دور تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .circle98' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );

   $this->add_responsive_control(
                        'farnamborder4',
                        [
                            'label' => esc_html__( 'گردی دور ایکون', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .box-simage-havine-2 i' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );

	$this->add_control(
			'titlegerd',
			[
				'label' => __( 'درجه چرخش نیم دایره', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
  'selectors' => [
                                '{{WRAPPER}} .circle98' => 'transform: rotate({{VALUE}}deg) !important;',
                            ],			]
		);

		$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
			echo "
			
			<a href='$settings[link]' class='box-simage-havine-1'>

			<div class='box-simage-havine-2'>
			<div class='circle98' data-anim='base right'></div>
			";
	
			echo '<img src="' . $settings['image']['url'] . '">
';
		?>
	<?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
	
		<?php

echo "
</div>
<div class='havine-345345-34534'>
			<h4>$settings[title] </h4>		
			<h6>$settings[title1] </h6>		
</div>
</a>

		";
			

	

	}


	
	protected function _content_template() {

    }
	
	
}