 <?php
 
 
 /* Order tracking form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/order/form-tracking.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woo.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit;

global $post;

// اگر شماره سفارش وجود دارد و فرم ارسال شده است
if (isset($_GET['orderid']) && !empty($_GET['orderid'])) {
    $order_number = wc_clean($_GET['orderid']);

    // یافتن اطلاعات سفارش بر اساس شماره سفارش
    $order = wc_get_order($order_number);

    // اگر سفارش وجود دارد
    if ($order) {
        // نمایش اطلاعات سفارش

        // ... دیگر اطلاعات مورد نیاز را اضافه کنید

        // نمایش جزئیات سفارش از فایل tracking.php
        include(locate_template('woocommerce/order/tracking.php'));

    } else {
        // اگر سفارش یافت نشد
        echo '<div class="khata-error-red">سفارشی با این اطلاعات یافت نشد . لطفا اطلاعات را بررسی و مجدد امتحان کنید</div>';
    }
}
?>
<style>
.woocommerce-error {
	display: none;
}
</style>



<div class="topsvg-linst">
<img src="<?php echo get_template_directory_uri(); ?>/img/resid.png">
</div>
<form action="" method="get" class="woocommerce-form woocommerce-form-track-order track_order order-newsbox">


    <?php
    /**
     * Action hook fired at the beginning of the form-tracking form.
     *
     * @since 6.5.0
     */
    do_action( 'woocommerce_order_tracking_form_start' );
    ?>

    <p class="box-tozih-order-tracking">لطفا شماره پیگیری محصول که در هنگام خرید دریافت کردید را وارد کنید</p>

    <p class="form-row form-row-firstertertert">
        <input class="input-text" type="text" name="orderid" id="orderid" value="<?php echo isset( $_REQUEST['orderid'] ) ? esc_attr( wp_unslash( $_REQUEST['orderid'] ) ) : ''; ?>" placeholder="<?php esc_attr_e( 'Found in your order confirmation email.', 'woocommerce' ); ?>" />
          <button type="submit" class="button<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" name="track" value="<?php esc_attr_e( 'Track', 'woocommerce' ); ?>"><i class="fi fi-rr-search"></i></button>


  </p>

    <?php
    /**
     * Action hook fired in the middle of the form-tracking form (before the submit button).
     *
     * @since 6.5.0
     */
    do_action( 'woocommerce_order_tracking_form' );
    ?>

  
    <?php wp_nonce_field( 'woocommerce-order_tracking', 'woocommerce-order-tracking-nonce' ); ?>

    <?php
    /**
     * Action hook fired at the end of the form-tracking form (after the submit button).
     *
     * @since 6.5.0
     */
    do_action( 'woocommerce_order_tracking_form_end' );
    ?>

</form>