<?php
/**
 * Dokan Seller Single product tab Template
 *
 * @since 2.4
 *
 * @package dokan
 */
?>

<h2><?php esc_html_e( 'Vendor Information', 'dokan-lite' ); ?></h2>

<ul class="list-unstyled dokan-seller-dsdew list-unstyledyt">
    <?php do_action( 'dokan_product_seller_tab_start', $author, $store_info ); ?>



    <li>


  <span class="boldsho"><i class="mdi mdi-account-outline"></i></span>
        <span class="details cvgdfrgerer555">
            <?php printf( '<a href="%s">%s</a>', esc_url( dokan_get_store_url( $author->ID ) ), esc_attr( $author->display_name ) ); ?>
        </span>
    </li>
    <?php if ( !empty( $store_info['store_name'] ) ) { ?>
        <li class="store-name sdkfksdf5">
            <span class="details">
                <?php echo esc_html( $store_info['store_name'] ); ?>
            </span>
        </li>
    <?php } ?>

    <li class="clearfix">
        <?php echo wp_kses_post( dokan_get_readable_seller_rating( $author->ID ) ); ?>
    </li>

    <?php do_action( 'dokan_product_seller_tab_end', $author, $store_info ); ?>
</ul>
