<?php
namespace Elementor;

class wcategory extends Widget_Base {
	
	public function get_name() {
		return 'wcategory';
	}
	
	public function get_title() {
		return 'دسته بندی 2';
	}
	
 public function get_icon() {
		return 'eicon eicon-menu-bar';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }

	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'عنوان خود را وارد کنید', 'elementor' ),
			]
		);
		
		$this->add_control(
			'image',
			[
				'label' => __( 'تصویر دسته بندی', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
				$this->add_control(
			'link',
			[
				'label' => __( 'لینک دسته بندی', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'ادرس لینک را وارد کنید', 'elementor' ),
			]
		);

$this->add_control(
			'color',
			[
				'label' => __( 'رنگ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
		
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
$this->add_control(
			'color544554',
			[
				'label' => __( 'رنگ ایکون', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
		
				'selectors' => [
					'{{WRAPPER}} .tedad-1-cat-ravesh-1' => 'color: {{VALUE}}',
				],
			]
		);
$this->add_control(
			'icon',
			[
				'label' => __( 'ایکون', 'text-domain' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);

	   $this->add_responsive_control(
                        'farnamborder1',
                        [
                            'label' => esc_html__( 'گردی دور دسته بندی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .ravesh-1-cat' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
   $this->add_responsive_control(
                        'farnamborder2',
                        [
                            'label' => esc_html__( 'گردی دور ایکون', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .tedad-1-cat-ravesh-1' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );




		$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
			echo "<a class='ravesh-1-cat' href='$settings[link]' ";
		echo ' style="background: url(' . $settings['image']['url'] . ');">
';
		echo  "
		<div class='mikimouse' style='background: $settings[color];'></div>
<div class='tedad-1-cat-ravesh'>
<div class='tedad-1-cat-ravesh-1' style='background: $settings[color];'>

";
	?>
			<?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
	
		<?php
	
			echo  "

</div>

</div>

<h4>$settings[title]</h4>
</a>
";
	}


	
	protected function _content_template() {

    }
	
	
}