<?php
namespace Elementor;

class blogsix extends Widget_Base {
	
	public function get_name() {
		return 'blogsix';
	}
	
	public function get_title() {
		return 'لیست مطالب عمودی';
	}
	
		
    public function get_icon() {
		return 'eicon eicon-posts-group';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }
	
	protected function register_controls() {

		$post_cat = array();
		$categories = get_terms("category");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
			foreach ( $categories as $category ) {
				$post_cat[ $category->term_id ] = $category->name;
			}
		}
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		


		
		$this->add_control(
			'title',
			[
				'label' => 'عنوان',
				'label_block' => true,
				'default' => 'مطالب',
				'type' => Controls_Manager::TEXT,
				'placeholder' => 'عنوان را وارد نمایید',
			]
		);

		$this->add_control(
			'post_sort',
			[
				'label' => 'مرتب سازی مطالب',
				'type' => Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'  => 'آخرین مطالب',
					'random' => 'مطالب تصادفی',
					'viewed' => 'مطالب پربازدید',
				],
			]
		);

		$this->add_control(
			'post_cat',
			[
				'label' => 'دسته بندی مطالب',
				'type' => Controls_Manager::SELECT2,
				'options' => $post_cat,
			]
		);




		$this->add_control(
			'ptotalcount',
			[
				'label' => 'تعداد مطالب',
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 20,
				'step' => 1,
				'default' => 8,
			]
		);


					

		$this->end_controls_section();
		
		
		$this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );
		$this->add_control(
			'farnamoneshow1',
			[
				'label' => __( 'نمایش تاریخ', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		
       $this->add_control(
			'farnamoneshow2',
			[
				'label' => __( 'نمایش دیدگاه', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		

        $this->end_controls_section();

	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );

		   
	
		   
		   $this->add_control(
'color_farnam_2',
			[
				'label' => __( 'رنگ پس زمینه تاریخ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .blog-2021-5-402' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'color_farnam_3',
			[
				'label' => __( 'رنگ تاریخ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .blog-2021-5-402' => 'color: {{VALUE}} !important',
				],
			]
           );

		   $this->add_control(
'color_farnam_4',
			[
				'label' => __( 'پس زمینه عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .comment-title-402-4' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   	 	   $this->add_control(
'color_farnam_6',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .comment-title-402-4 h4' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		 	   $this->add_control(
'color_farnam_5',
			[
				'label' => __( 'رنگ پس زمینه دیدگاه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .didgah-402-box' => 'background: {{VALUE}} !important',
				],
			]
           );  
		   
		   	   	 	   $this->add_control(
'color_farnam_7',
			[
				'label' => __( 'رنگ متن دیدگاه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .didgah-402-box' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		      	   	 	   $this->add_control(
'color_farnam_8',
			[
				'label' => __( 'رنگ پس زمینه دکمه اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .post-block.m-product.ir99.mkl-402-1 .owl-nav button' => 'background: {{VALUE}} !important',
				],
			]
           );  
		   
		   		      	   	 	   $this->add_control(
'color_farnam_9',
			[
				'label' => __( 'رنگ دکمه اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .post-block.m-product.ir99.mkl-402-1 .owl-nav button' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		   		   
		   
		   $this->add_responsive_control(
                        'farnamborder1',
                        [
                            'label' => esc_html__( 'گردی تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .blog-new-402 img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );

  $this->add_responsive_control(
                        'farnamborder2',
                        [
                            'label' => esc_html__( 'گردی دور تاریخ', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .blog-2021-5-402' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
				  $this->add_responsive_control(
                        'farnamborder3',
                        [
                            'label' => esc_html__( 'گردی باکس عنوان', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .comment-title-402-4' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
								  $this->add_responsive_control(
                        'farnamborder4',
                        [
                            'label' => esc_html__( 'گردی تعداد دیدگاه ', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .didgah-402-box' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
					
					
					  $this->add_responsive_control(
                        'farnamborder46556',
                        [
                            'label' => esc_html__( 'گردی دکمه اسلایدر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .post-block.m-product.ir99.mkl-402-1 .owl-nav button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
					
						
				

        $this->end_controls_section();


	}
	
	protected function render() {
		global $az_data;
		$settings = $this->get_settings_for_display();
		$post_cat = $settings['post_cat']; ?>
        <div class="rcon">
			<div class="post-block m-product ir99 mkl-402-1">
		
			<?php
			$post_sort = $settings['post_sort'];
				switch ($post_sort) {
					case 'latest':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
						break;
					case 'viewed':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'meta_key' => 'post_views_count',
						'orderby' => 'meta_value_num',
						'order' => 'DESC'  );
						break;
					case 'random':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'orderby'        => 'rand'  );
						break;
					default:
					$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
					}
					if ( $post_cat ) {
						$args['tax_query'] = array(
							array(
							'taxonomy' => 'category',
							'field' => 'term_id',
							'terms' => $post_cat
							)
						);
					}
				$postsquery = new \WP_Query( $args );
			?>
			
			<?php if ( $postsquery->have_posts() ) { ?>

			<script>
			
			   $(document).ready(function(){
$('.owl-blogonewe').owlCarousel({
    loop:true,
     autoplay:true,
    autoplayTimeout:7000,
    autoplayHoverPause:true,
    rtl: true,
    nav:true,
	dots:true,
        margin:10,
    dots: false,
    responsive:{
        0:{
            items:1
        },
        850:{
            items:2
        },
        1200:{
            items:3
        }
    }
})
});

</script>
		                   <div class="owl-blogonewe owl-carousel bxboxone">

			<?php while ( $postsquery->have_posts() ) : $postsquery->the_post(); ?>
			
			
			<div class="blog-new-402">
			<a href="<?php the_permalink(); ?>">
			<div class="blog-new-4022">
			<div class="blog-new-402-2-img">
			
				<?php the_post_thumbnail(''); ?>
				<?php if ( 'yes' === $settings['farnamoneshow1'] ) { ?>
<div class="blog-2021-5-402">
<?php the_time('d M Y'); ?>
</div><?php } ?>
</div>


<div class="comment-title-402-4">
<h4><?php the_title(); ?></h4>	<?php if ( 'yes' === $settings['farnamoneshow2'] ) { ?>
<div class="didgah-402-box">
<i class="fi fi-rr-comment"></i>
<?php comments_number( '0', ' 1 ', ' % ' ); ?>

</div><?php } ?>
</div>
			</a>
			</div></div>

			<?php endwhile; ?>
				</div>
			<?php 
			} else {		
			echo 'لطفا ابتدا نوشته ای را اضافه نمایید.';}
			wp_reset_postdata();
			?>
			</div>
   		</div>
        <?php

	}

}