<?php
/**

 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     4.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if(!function_exists('sc_populate_products_page')){
    function sc_populate_products_page() {
        global $wpdb;

global $wpdb;

// شناسه کاربر فعلی
$current_user = wp_get_current_user();
if ($current_user->ID == 0) return [];

// آماده‌سازی کوئری
$query = $wpdb->prepare(
    "
    SELECT p.ID
    FROM {$wpdb->posts} p
    INNER JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id
    WHERE p.post_type = 'shop_order'
    AND p.post_status = 'wc-completed'
    AND pm.meta_key = '_customer_user'
    AND pm.meta_value = %d
    ",
    $current_user->ID
);

// اجرای کوئری
$customer_orders = $wpdb->get_col($query);

        if (empty($customer_orders)) return "0";

        // دریافت همه product_id ها با یک کوئری
        $order_ids_placeholder = implode(',', array_fill(0, count($customer_orders), '%d'));
        $query = "
            SELECT order_itemmeta.meta_value as product_id 
            FROM {$wpdb->prefix}woocommerce_order_items as order_items
            INNER JOIN {$wpdb->prefix}woocommerce_order_itemmeta as order_itemmeta
                ON order_items.order_item_id = order_itemmeta.order_item_id
            WHERE order_items.order_id IN ($order_ids_placeholder)
            AND order_itemmeta.meta_key = '_product_id'
        ";

        $prepared_query = $wpdb->prepare($query, ...$customer_orders);
        $results = $wpdb->get_col($prepared_query);

        // حذف تکراری‌ها و شمارش
        $product_ids = array_unique($results);

        echo count($product_ids);
    }
}

$allowed_html = array(
    'a' => array(
        'href' => array(),
    ),
);

?>

<p class="ligin"><?php
	/* translators: 1: user display name 2: logout url */
	printf(
		__( 'Hello %1$s (not %1$s? <a href="%2$s">Log out</a>)', 'woocommerce' ),
		'<strong>' . esc_html( $current_user->display_name ) . '</strong>',
		esc_url( wc_logout_url( wc_get_page_permalink( 'myaccount' ) ) )
	);
?></p>


 <?php if((get_option('acc1') == true )): ?>

<div class="ete">

<div class="user-a">
<div class="user-a-1">
<div class="iconuser r-21">
<i class="mdi mdi-basket"></i>
</div>
<div class="disk-1">

<h2>محصولات خریداری شده

</h2>

<div class="boete1"><?php echo number_format( count( es_get_customer_bought_products() ) ); ?></div>
</div></div></div>


<div class="user-a">
<div class="user-a-1">
<div class="iconuser r-21" style="background: linear-gradient(180deg,#fecf6c,#ffbe70);box-shadow: rgba(254,206,108,.65) 0 2px 15px;">
<i class="mdi mdi-card-bulleted-outline"></i>

</div>
<div class="disk-1">
<h2>مبلغ سفارشات شما

</h2>

<div class="boete1"><?php echo wc_price( es_get_customer_total_order() ); ?></div>

</div></div>
</div>

<div class="user-a">
<div class="user-a-1">
<div class="iconuser r-21" style="background: linear-gradient(180deg,#aae181,#89d351);box-shadow: rgba(137,211,81,.43) 0 2px 15px;">
<i class="mdi mdi-comment-processing-outline"></i>

</div>
<div class="disk-1">

<h2>کل دیدگاه ها

</h2>

<div class="boete1"><?php echo es_comment_count( get_current_user_id() ); ?></div>

</div></div></div>

</div>	
	<?php endif; ?>
	
	
<div class="sepid-sefaresh">
<div class="sepid-sefaresh1">
<div class="box-asli-user" id="order-dashboard-box">
    <div class="box-order-dashboard-title">
        آخرین سفارش های شما
    </div>

    <script>
        $(document).ready(function(){
            $('.owl-orders').owlCarousel({
                loop: false,
                rtl: true,
                nav: true,
                dots: true,
                margin: 0,
                dots: false,
                responsive: {
                    0: {
                        items: 1
                    },
                    500: {
                        items: 1
                    },
                    900: {
                        items: 1
                    },
                    1200: {
                        items: 2
                    }
                }
            });
        });
    </script>

    <?php
    if ( ! class_exists( 'WooCommerce' ) ) {
        return;
    }

    $current_user = wp_get_current_user();

    $args = array(
        'customer_id' => $current_user->ID,
        'limit' => 10, 
        'orderby' => 'date',
        'order' => 'DESC',
    );

    $orders = wc_get_orders( $args );
    ?>

    <?php if ( ! empty( $orders ) ) : ?>
        <div class="owl-orders owl-carousel bxboxone">
            <?php foreach ( $orders as $order ) : ?>
                <div class="order-mehrnoosh-list-box">										

                    <div class="order-mehrnoosh-list-box1">
                        <div class="order-mehrnoosh-list-box1-mehr-bx-blur">
                            <div class="order-mehrnoosh-list-box23">

                                <div class="order-mehrnoosh-list-box2">

                                    <div class="iran000wrwerwe postnumber-no-mehrnoosh <?php echo esc_html( wc_get_order_status_name( $order->get_status() ) ); ?>">
                                        <?php echo esc_html( wc_get_order_status_name( $order->get_status() ) ); ?>
                                    </div>

                                    <div class="order-list-name-img-fegerger1">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none"> 
                                            <path d="M6.66699 2.16663V4.66663" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path> 
                                            <path d="M13.333 2.16663V4.66663" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path> 
                                            <path d="M2.91699 8.07495H17.0837" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path> 
                                            <path d="M17.5 7.58329V14.6666C17.5 17.1666 16.25 18.8333 13.3333 18.8333H6.66667C3.75 18.8333 2.5 17.1666 2.5 14.6666V7.58329C2.5 5.08329 3.75 3.41663 6.66667 3.41663H13.3333C16.25 3.41663 17.5 5.08329 17.5 7.58329Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path> 
                                            <path d="M13.0791 11.9167H13.0866" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> 
                                            <path d="M13.0791 14.4167H13.0866" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> 
                                            <path d="M9.99607 11.9167H10.0036" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> 
                                            <path d="M9.99607 14.4167H10.0036" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> 
                                            <path d="M6.91209 11.9167H6.91957" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> 
                                            <path d="M6.91209 14.4167H6.91957" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> 
                                        </svg>
                                        تاریخ :
                                        <time datetime="<?php echo esc_attr( $order->get_date_created()->date( 'c' ) ); ?>">
                                            <?php echo esc_html( wc_format_datetime( $order->get_date_created() ) ); ?>
                                        </time>
                                    </div>

                                </div>
                            </div>

                            <div class="order-list-name-img-fegerger">
                                <div class="order-products-list-img">
                                    			<?php
$order_items = $order->get_items();

if (!empty($order_items)) {
    foreach ($order_items as $item) {
        $product = $item->get_product();
        if ($product) { 
            $product_image = wp_get_attachment_image_url($product->get_image_id(), 'thumbnail'); 
            echo '<div class="tasvir-dfgdfg">';
           if (!empty($product_image)) {
            echo '<img src="' . esc_url($product_image) . '" alt="' . esc_attr($product->get_name()) . '" class="product-image" />';
        } else {
            echo '<img src="' . esc_url(wc_placeholder_img_src()) . '" alt="تصویر پیش‌فرض محصول" class="product-image" />';
        }
            echo '</div>';
        } else {
            echo '<p></p>';
        }
    }
} else {
    echo '<p></p>';
}
?>
                                </div>
                            </div>

                            <div class="axtion-mehrnoosh-list">
                                <div class="order-mehrnoosh-list-box13">
                                 
                                    کد سفارش <?php echo $order->get_order_number() ?>
                                </div>
<?php
$actions = wc_get_account_orders_actions( $order );

if ( ! empty( $actions ) ) {
    foreach ( $actions as $key => $action ) {
        echo '<a href="' . esc_url( $action['url'] ) . '" class="woocommerce-button button ' . sanitize_html_class( $key ) . '">' . esc_html( $action['name'] ) . '</a>';
    }
}
?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else : ?>
	
	<div class="mehrnoosh-no-product-shop-in-my-account">
	<i class="fi fi-rr-basket-shopping-simple"></i>
        <p>شما هنوز سفارشی ثبت نکرده‌اید.</p>
    <?php endif; ?>
</div>
</div>
</div>
	
	
	
	 <?php if((get_option('acc2') == true )): ?>

<div class="elk" id="etelae">
<div class="elkone">
<h3 class="title-2">اطلاعیه های سایت

</h3>
<?php $query = new WP_Query(array('post_type' =>'elai',
	'posts_per_page'  => 10));
	if ($query){while($query->have_posts()) : $query->the_post(); ?>
	<a class="elktwo" href="<?php the_permalink(); ?>">	<?php the_post_thumbnail('thumbnail'); ?>
	<div class="elk-1">
	<span><i class="mdi mdi-timer"></i><?php the_time('d M Y'); ?></span>
	<h3><?php the_title(); ?></h3> 
	</div>
	
	</a>

	<?php endwhile; } ?>
	</div></div>	<?php endif; ?>

	<?php 
	do_action( 'woocommerce_after_my_account' );

?>
<?php
	/**
	 * My Account dashboard.
	 *
	 * @since 2.6.0
	 */
	do_action( 'woocommerce_account_dashboard' );

	/**
	 * Deprecated woocommerce_before_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_before_my_account' );

	/**
	 * Deprecated woocommerce_after_my_account action.
	 *
	 * @deprecated 2.6.0
	 */

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
