<?php
namespace Elementor;

class iconfarnam1 extends Widget_Base {
	
	public function get_name() {
		return 'iconfarnam1';
	}
	
	public function get_title() {
		return 'آیکون فرنام 2';
	}
	
 public function get_icon() {
		return 'eicon eicon-menu-bar';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }

	
	protected function register_controls() {


		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'عنوان خود را وارد کنید', 'elementor' ),
			]
		);



	
$this->add_control(
			'icon',
			[
				'label' => __( 'ایکون', 'text-domain' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);


	$this->add_control(
			'color45',
			[
				'label' => __( 'رنگ پس زمینه ایکون', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .koodak-cat-new-1-innermk-0005TTTGG' => 'background: {{VALUE}} !important',
				],
			]
		);
		
		$this->add_control(
			'color455',
			[
				'label' => __( 'رنگ ایکون', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .koodak-cat-new-1-innermk-0005TTTGG' => 'color: {{VALUE}} !important',
				],
			]
		);
		
				$this->add_control(
                        'titr-124444-44r464345rw',
                        [
                            'label' => __( 'سایه ایکون', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow34',
				'selector' => '{{WRAPPER}} .koodak-cat-new-1-innermk-0005TTTGG',
			]
		);
			


   $this->add_responsive_control(
                        'farnamborder2',
                        [
                            'label' => esc_html__( 'گردی ایکون', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .koodak-cat-new-1-innermk-0005TTTGG' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );


		$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
	
echo "
			<div class='koodak-cat-new-1-innermk-0005TTTGG'>
			
	
		";
				?>
			<?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
	
		<?php
		echo"
			
			</div>
			
";
	

	}


	
	protected function _content_template() {

    }
	
	
}