<?php
namespace Elementor;

class footerone extends Widget_Base {
	
	public function get_name() {
		return 'footerone';
	}
	
	public function get_title() {
		return 'آیکون پابرگ';
	}
	
    public function get_icon() {
		return 'eicon eicon-parallax';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'عنوان خود را وارد کنید', 'elementor' ),
			]
		);
		$this->add_control(
			'zirtitle',
			[
				'label' => __( 'ایکون - material design icons', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'کد ایکون', 'elementor' ),
			]
		);


		
	
		$this->end_controls_section();
	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();
			echo  "	
			
			
			<div class='mrfooter-box footer-one-elementor'>
<i class='mdi $settings[zirtitle]'></i>
<h4>$settings[title]</h4>
</div>

";

		 

	}
	
	protected function _content_template() {

    }
	
	
}