<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

class WAST_Flash_Message {

	/**
	 * Message
	 * @var
	 */
	protected $_messages;

	/**
	 * Alert types
	 */
	const ERROR = 1;
	const SUCCESS = 2;
	const WARNING = 3;
	const INFO = 4;

	/**
     * Save error
	 * @var
	 */
	public static $has_error;

	/**
	 * Add message to session array
	 *
	 * @param string $message
	 * @param int $type
	 */
	public static function add_message( $message = "", $type = self::SUCCESS ) {
		if ( ! isset( $_SESSION['wast']['messages'] ) ) {
			$_SESSION['wast']['messages'] = array();
		}
		if ( $type == self::ERROR ) {
			self::$has_error = true;
		}
		$_SESSION['wast']['messages'][] = array(
			'body' => $message,
			'type' => $type
		);
	}

	/**
	 * Show message
	 */
	public static function show_message() {
		if ( isset( $_SESSION['wast']['messages'] ) && ! empty( $_SESSION['wast']['messages'] ) ) {
			foreach ( $_SESSION['wast']['messages'] as $message ) {
				$alert_class = self::get_alert_type( $message['type'] )
				?>
                <div class="<?php echo is_admin() ? 'notice is-dismissible' : 'wast-alert'; ?> <?php echo $alert_class; ?>">
                    <p><?php echo $message['body']; ?></p>
                </div>
				<?php
			}
			self::empty_bag();
		}
	}

	/**
	 * Get alert type
	 *
	 * @param $type
	 *
	 * @return string
	 */
	public static function get_alert_type( $type ) {
		switch ( $type ) {
			case self::SUCCESS:
				if ( is_admin() ) {
					return 'notice-success';
				} else {
					return 'wast-alert-success';
				}
				break;
			case self::ERROR:
				if ( is_admin() ) {
					return 'notice-error';
				} else {
					return 'wast-alert-danger';
				}
				break;
			case self::WARNING;
				if ( is_admin() ) {
					return 'notice-warning';
				} else {
					return 'wast-alert-warning';
				}
				break;
			case self::INFO:
				if ( is_admin() ) {
					return 'notice-info';
				} else {
					return 'wast-alert-info';
				}
				break;

		}
	}

	/**
	 * Make session and $has_error variable empty for next use
	 */
	public static function empty_bag() {
		$_SESSION['wast']['messages'] = array();
		self::$has_error              = false;
	}
}