<?php
namespace Elementor;

class headerseven extends Widget_Base {
	
	public function get_name() {
		return 'headerseven';
	}
	
	public function get_title() {
		return 'باکس سربرگ 3';
	}
	
	    public function get_icon() {
		return 'eicon eicon-header';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
		$this->add_control(
			'posts_per_page',
			[
				'label' => __( 'عنوان', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'یک عنوان وارد کنید', 'elementor' ),
			]
		);
		$this->add_control(
'title_color',
			[
				'label' => __( 'رنگ پس زمینه کاربری', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .titlekarbar' => 'background: {{VALUE}} !important',
				],
			]
		);
								$this->add_control(
'color-two4',
			[
				'label' => __( 'رنگ متن کاربری', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .titlekarbar' => 'color: {{VALUE}} !important',
				],
			]
		);
				$this->add_control(
'color-two',
			[
				'label' => __( 'رنگ ایکون کاربری', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
		
				'selectors' => [
					'{{WRAPPER}} .iconusertitle i' => 'color: {{VALUE}} !important',
				],
			]
		);
		
						$this->add_control(
'color-two3',
			[
				'label' => __( 'رنگ کادر کاربری', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .titlekarbar' => 'border-color: {{VALUE}} !important',
				],
			]
		);
								$this->add_control(

		'color-four',
			[
				'label' => __( 'رنگ پس زمینه سبد خرید', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .cartnimshe-422-1400' => 'background: {{VALUE}} !important',
				],
			]
		);
		
								$this->add_control(

		'color-fourt5',
			[
				'label' => __( 'رنگ متن سبد خرید', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .cartnimshe-422-1400' => 'color: {{VALUE}} !important',
				],
			]
		);
		
		
		
								$this->add_control(

		'color-four555g',
			[
				'label' => __( 'رنگ پس زمینه دکمه منو موبایل', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .left-sabad.menu-resp.menu-1400-556' => 'background: {{VALUE}} !important',
				],
			]
		);
		
								$this->add_control(

		'color-fourt5fff',
			[
				'label' => __( 'رنگ متن منو دکمه منو موبایل', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
		
				'selectors' => [
					'{{WRAPPER}} .left-sabad.menu-resp.menu-1400-556' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'show_title1',
			[
				'label' => __( 'نمایش سبد خرید', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_title2',
			[
				'label' => __( 'نمایش حساب کاربری', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
					$this->add_responsive_control(
                        'farnam-p-2-9',
                        [
                            'label' => esc_html__( 'گردی حساب کاربری', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .titlekarbar' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
				$this->add_responsive_control(
                        'farnam-p-2-94rt5',
                        [
                            'label' => esc_html__( 'گردی سبد خرید', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .cartnimshe-422-1400' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
					
							$this->add_responsive_control(
                        'farnam-p-2-94rt5',
                        [
                            'label' => esc_html__( 'گردی دکمه منو موبایل', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .left-sabad.menu-resp.menu-1400-556' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings_for_display();
		

		?>

<div class="left-header-box header-one-one-4 ss-nn-xx-11">
 <?php if ( 'yes' === $settings['show_title1'] ) { ?>

 <span  class="left-sabad min-car-6 gtr-654 sabadcolortitle cartnimshe-422-1400">
<i class="fi fi-rr-shopping-bag"></i><pg>سبد خرید</pg> <span class="sabadnumbercolor"><div class="header-cart-count"><?php echo WC()->cart->get_cart_contents_count(); ?></div></span>
<div class="mini-cart-3">

<div class="widget_shopping_cart_content"><?php woocommerce_mini_cart(); ?></div> </div>
</span>
 <?php } ?>
 <?php if ( 'yes' === $settings['show_title2'] ) { ?>


<?php if ( is_user_logged_in() ) { ?>


<div class="left-rr-user kkj-33434 gtr-654 gggg-f titlekarbar iconusertitle useriranboxine-999-1400">
<i class="fi fi-rr-user"></i>  <p>حساب کاربری</p>
<div class="user-meta">
<a href="<?php echo home_url() ?>/my-account/"><i class="mdi mdi-view-dashboard-outline"></i>پنل کاربری </a>
<a href="<?php echo home_url() ?>/my-account/edit-account/"><i class="mdi mdi-account-outline"></i>ویرایش حساب کاربری </a>
<a href="<?php echo home_url() ?>/my-account/orders/"><i class="mdi mdi-card-bulleted-outline"></i> سفارش های شما </a>
<a href="<?php echo home_url() ?>/my-account/mywishlist/"><i class="mdi mdi-heart"></i> علاقه مندی های شما </a>

<div class="log-111">

<a  href="<?php echo home_url() ?>/my-account/customer-logout/"> <i class="mdi mdi-account-arrow-left-outline"></i>خروج از سایت </a>

</div>
</div>
</div>


 <?php } 
 else { ?>
 <a href="<?php echo home_url() ?>/my-account/" class="left-rr-user gtr-654 gggg-f titlekarbar iconusertitle useriranboxine-999-1400">
<i class="fi fi-rr-user"></i>  <p>ورود و عضویت </p>
</a>
 <?php } ?>
  <?php } ?>



<a class="left-sabad menu-resp menu-1400-556" onclick="openNav()">
<i class="mdi mdi-menu"></i>
</a>

</div>


<div id="mySidenav" class="sidenav">
  <a href="javascript:void(0)" class="closebtn" onclick="closeNav()">&times;</a>
<div class="mob-1"> 
          <form class="search" method="get" action="<?php bloginfo('url'); ?>">
<input type="text" placeholder="دنبال چی هستی؟
" onfocus="if (this.value == '') {this.value = '';}" onblur="if (this.value == '') {this.value = '';}" name="s" class="text">

<button type="submit" class="submit icon-search"><i class="mdi mdi-magnify"></i></button>
<input type="hidden" name="post_type" value="product" />
</form>

</div>
<div class="mobile-menu-1 stellarnav">
 <?php 
                        $defaults = array(
                            'theme_location' => 'header-menu',
                            'menu' => '',
                            'container' => '',
                            'container_class' => '',
                            'container_id' => '',
                            'menu_class' => 'main_menu',
                            'menu_id' => '',
                            'echo' => true,
                            'fallback_cb' => 'wp_page_menu',
							    'add_li_class'  => 'mega',
                            'before' => '',
                            'after' => '',
                            'link_before' => '',
                            'link_after' => ' ',
                            'items_wrap' => '<ul id="header_main_nav" class="nav header-nav header-bottom-nav nav-center  nav-uppercase">%3$s</ul>',
                            'depth' => 0,
                            'walker' => ''
                            );
                        wp_nav_menu($defaults);
                    ?>
</div>

<!-- required -->
	<script type="text/javascript">
		jQuery(document).ready(function($) {
			jQuery('.stellarnav').stellarNav({
				theme: 'dark',
				breakpoint: 1024,
				position: 'right',
				phoneBtn: '18009997788',
				locationBtn: 'https://www.google.com/maps'
			});
		});
	</script>
	<!-- required -->
	</div>

 <script>
/* Set the width of the side navigation to 250px */
function openNav() {
  document.getElementById("mySidenav").style.width = "300px";
}

/* Set the width of the side navigation to 0 */
function closeNav() {
  document.getElementById("mySidenav").style.width = "0";
} 
</script>
      <script type="text/javascript">   $('document').ready(function () {   $(".kkj-33434").click(function(){    $('.user-meta').slideToggle('slow');   });   });
</script>

      <script type="text/javascript">   $('document').ready(function () {   $(".trybut").click(function(){    $('.box-etel').slideToggle('slow');   });   });
</script>


		<?php
	}
	
	protected function _content_template() {

    }
	
	
}