<?php
namespace Elementor;

class cat1 extends Widget_Base {
	
	public function get_name() {
		return 'cat1';
	}
	
	public function get_title() {
		return 'دسته بندی فرنام استایل';
	}
	
	public function get_icon() {
		return 'eicon eicon-menu-bar';
	}
	
	public function get_categories() {
		return [ 'farnamstyle' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'عنوان خود را وارد کنید', 'elementor' ),
			]
		);
		$this->add_control(
			'adad',
			[
				'label' => __( 'تعداد محصولات', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'تعداد محصولات را با عدد مشخص کنید', 'elementor' ),
			]
		);
		$this->add_control(
			'link',
			[
				'label' => __( 'لینک دسته بندی', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'لینک مورد نظر را وارد کنید', 'elementor' ),
			]
		);

$this->add_control(
			'image',
			[
				'label' => __( 'انتخاب تصویر', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
	
	$this->add_control(
'color_farnam_1',
			[
				'label' => __( 'رنگ هاور پس زمینه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .daste-1:hover' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'color_farnam_2',
			[
				'label' => __( 'رنگ پس زمینه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .daste-1' => 'background: {{VALUE}}',
				],
			]
           );
		   		   $this->add_control(
'color_farnam_3',
			[
				'label' => __( 'رنگ کادر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .daste-1' => 'border-color: {{VALUE}}',
				],
			]
           );
		   
		   
		   		   		   $this->add_control(
'color_farnam_4',
			[
				'label' => __( 'رنگ شمارشگر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-number-cat' => 'background: {{VALUE}}',
					'{{WRAPPER}} .box-number-cat::before' => 'background: {{VALUE}}',
				],
			]
           );
		   
		   	   		   		   $this->add_control(
'color_farnam_5',
			[
				'label' => __( 'رنگ هاور شمارشگر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .daste-1:hover  .box-number-cat' => 'background: {{VALUE}}',
					'{{WRAPPER}} .daste-1:hover .box-number-cat::before' => 'background: {{VALUE}}',
				],
			]
           );
		   
		   
		   	   		   $this->add_control(
'color_farnam_6',
			[
				'label' => __( 'رنگ متن', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .daste-1 h3' => 'color: {{VALUE}}',
				],
			]
           );
		   
		    	   		   $this->add_control(
'color_farnam_7',
			[
				'label' => __( 'رنگ متن شمارشگر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-number-cat' => 'color: {{VALUE}}',
				],
			]
           );
		   
		   
		     $this->add_responsive_control(
                        'farnamborder1',
                        [
                            'label' => esc_html__( 'گردی دور دسته بندی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .daste-1' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					    $this->add_responsive_control(
                        'farnamborder2',
                        [
                            'label' => esc_html__( 'گردی دور شمارشگر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .box-number-cat' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
		$this->end_controls_section();
	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();
			echo  "	
<a href='$settings[link]' class='daste-1'>



";
				echo '<img class="img-daste-1" src="' . $settings['image']['url'] . '">
';
		echo  "
	<div class='box-number-cat'>$settings[adad]</div><h3>$settings[title]</h3>
</a>

		";
		 

	}
	
	protected function _content_template() {

    }
	
	
}