<?php
namespace Elementor;

class sliderimageone extends Widget_Base {
	
	public function get_name() {
		return 'sliderimageone';
	}
	
	public function get_title() {
		return 'اسلایدر تصویر';
	}
	
 public function get_icon() {
		return 'eicon eicon-menu-bar';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }

	
	protected function register_controls() {


		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'محتوا', 'elementor' ),
			]
		);
		
		
		
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'list_title',
		[
						'label' => esc_html__( 'عنوان اسلاید', 'textdomain' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'default' => esc_html__( 'عنوان اول' , 'textdomain' ),
						'label_block' => true,
					]
		);

		$repeater->add_control(
			'image',
			[
				'label' => esc_html__( 'تصویر اسلایدر', 'textdomain' ),
								'type' => \Elementor\Controls_Manager::MEDIA,

	'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'link',
			[
			'label' => esc_html__( 'لینک دسته بندی', 'textdomain' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'default' => esc_html__( '#' , 'textdomain' ),
						'show_label' => false,
						]
		);



		$this->add_control(
			'list',
			[
				'label' => esc_html__( 'تصاویر', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_title' => esc_html__( 'اسلاید 1', 'textdomain' ),
					],
					[
						'list_title' => esc_html__( 'اسلاید 2', 'textdomain' ),
					],
				],
				'title_field' => '{{{ list_title }}}',
			]
		);
		
		
		
		
		
	
		$this->end_controls_section();

       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
		
    $this->add_control(
'sepidcolor-1',
			[
				'label' => __( 'رنگ پس زمینه تصویر اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .slider-403-farvardin-image-slider-thumb #slider-big-image-403 .tedad-cat-403-111dfrr' => 'background: {{VALUE}}  !important',
				],
			]
           );
		   
		
						 

		     $this->add_control(
'sepidcolor-233',
			[
				'label' => __( 'رنگ کادر تصویر اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .slider-403-farvardin-image-slider-thumb #slider-big-image-403 .tedad-cat-403-111dfrr' => 'border-color: {{VALUE}} !important',
				],
			]
           );
  $this->add_control(
'sepidcolor-3',
			[
				'label' => __( 'رنگ کادر تصاویر کوچک', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} #slider-thumb-image-403-1 .tedad-cat-403-111dfrr' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		     $this->add_control(
'sepidcolor-3998776',
			[
				'label' => __( 'رنگ کادر تصویر کوچک فعال', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} #slider-thumb-image-403-1 .swiper-slide-thumb-active .tedad-cat-403-111dfrr' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		      $this->add_control(
'sepidcolor-344',
			[
				'label' => __( 'رنگ پس زمینه دکمه اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} #slider-thumb-image-403-1 .iran-button-slider' => 'background: {{VALUE}} !important',
				],
			]
           );
		       
		 $this->add_control(
'sepidcolor-342334243344',
			[
				'label' => __( 'رنگ ایکون دکمه اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} #slider-thumb-image-403-1 .iran-button-slider::after' => 'color: {{VALUE}} !important',
				],
			]
           );	   
			   	  
			
		      $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی تصویر اصلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .slider-403-farvardin-image-slider-thumb #slider-big-image-403 .tedad-cat-403-111dfrr' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                                '{{WRAPPER}} .slider-403-farvardin-image-slider-thumb #slider-big-image-403 .tedad-cat-403-111dfrr img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		   
		      $this->add_responsive_control(
                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی تصویر کوچک', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} #slider-thumb-image-403-1 .tedad-cat-403-111dfrr' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                                '{{WRAPPER}} #slider-thumb-image-403-1 .tedad-cat-403-111dfrr img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		   
	
		   	      $this->add_responsive_control(
                        'sepidborder-45',
                        [
                            'label' => esc_html__( 'گردی دکمه اسلایدر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} #slider-thumb-image-403-1 .iran-button-slider' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );

		$this->end_controls_section();
	}







protected function render() {
    $settings = $this->get_settings();

    ob_start();

    ?>
<div class="slider-403-farvardin-image-slider-thumb">

    <div id="slider-big-image-403" class="swiper mySwiper2">
        <div class="swiper-wrapper">
            <?php
            if ($settings['list']) {
                foreach ($settings['list'] as $item) {
                    ?>
                    <div class="swiper-slide">
                        <a href="<?php echo $item['link']; ?>" class="link-cat-21123 elementor-repeater-item-<?php echo esc_attr($item['_id']); ?>">
                            <div class="tedad-cat-403-111dfrr">
                                <img src="<?php echo $item['image']['url']; ?>">
                            </div>
                        </a>
                    </div>
                    <?php
                }
            }
            ?>
        </div>
    </div>  <div id="slider-thumb-image-403-1">
    <div id="slider-thumb-image-403" class="swiper mySwiper">
        <div class="swiper-wrapper">
            <?php
            if ($settings['list']) {
                foreach ($settings['list'] as $item) {
                    ?>
                    <div class="swiper-slide">
                       
                            <div class="tedad-cat-403-111dfrr">
                                <img src="<?php echo $item['image']['url']; ?>">
                            </div>
                     
                    </div>
                    <?php
                }
            }
            ?>
        </div>
    </div>  <div class="swiper-button-next iran-button-slider"></div>
    <div class="swiper-button-prev iran-button-slider"></div>   </div>
    </div>   
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var swiper = new Swiper(".mySwiper", {
                spaceBetween: 10,
                slidesPerView: 4,
                freeMode: true,
	
                watchSlidesProgress: true,
				                slidesPerView: 4,

            });
			

            var swiper2 = new Swiper(".mySwiper2", {
                spaceBetween: 10,

			 autoplay: {
        delay: 2500,
        disableOnInteraction: false,
      },
                navigation: {
                    nextEl: ".swiper-button-next",
                    prevEl: ".swiper-button-prev",
                },
                thumbs: {
                    swiper: swiper,
                },
            });
        });
    </script>
    <?php

    echo ob_get_clean();
}


	
	


}
